function [beta]=crude_discretrization_OLS(x);

% Purpose: estimate the OU parameters based on the crude-Euler
% discretization
% input: x - Tx1 vector of data
% output: beta: 4x1 vector of auxiliary parameters

T=size(x,1);

X=[ones(T-1,1),x(1:end-1)]; % use AR(1) + intercept

results=ols(x(2:end),X);

%% Additional moments (variance of x)

M4=var(x);

% Beta is 4x1 vector
beta=[results.beta(1:2)',sqrt(results.sige'),M4]';